/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiRect;
import se.mickelus.mutil.gui.GuiRoot;
import se.mickelus.mutil.gui.animation.Applier;
import se.mickelus.mutil.gui.animation.KeyframeAnimation;

@ParametersAreNonnullByDefault
public class GuiBlockProgress
extends GuiRoot {
    private static final int width = 16;
    private final KeyframeAnimation showAnimation;
    private final KeyframeAnimation hideAnimation;
    private final GuiElement container = new GuiElement(-1, 20, 16, 2).setAttachment(GuiAttachment.middleCenter).setOpacity(0.0f);
    private final GuiRect bar;

    public GuiBlockProgress(Minecraft mc) {
        super(mc);
        this.addChild(this.container);
        this.container.addChild(new GuiRect(0, 0, 16, 2, 0xFFFFFF).setOpacity(0.2f));
        this.bar = new GuiRect(0, 0, 0, 2, 0xFFFFFF);
        this.bar.setOpacity(0.6f);
        this.container.addChild((GuiElement)this.bar);
        this.showAnimation = new KeyframeAnimation(60, this.container).applyTo(new Applier[]{new Applier.Opacity(1.0f), new Applier.TranslateX(0.0f)});
        this.hideAnimation = new KeyframeAnimation(100, this.container).applyTo(new Applier[]{new Applier.Opacity(0.0f), new Applier.TranslateX(-2.0f)}).withDelay(1000);
    }

    public void setProgress(float progress) {
        if (progress > 0.0f) {
            this.bar.setWidth(Mth.m_14045_((int)((int)(progress * 16.0f)), (int)0, (int)16));
            if (!this.showAnimation.isActive() && this.container.getOpacity() < 1.0f) {
                this.showAnimation.start();
            }
            this.hideAnimation.stop();
        } else {
            if (!this.hideAnimation.isActive() && this.container.getOpacity() > 0.0f) {
                this.hideAnimation.start();
            }
            this.showAnimation.stop();
        }
    }

    public void draw(PoseStack matrixStack) {
        if (this.isVisible()) {
            Window window = this.mc.m_91268_();
            int width = window.m_85445_();
            int height = window.m_85446_();
            int mouseX = (int)(this.mc.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_());
            int mouseY = (int)(this.mc.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_());
            this.drawChildren(matrixStack, width / 2, height / 2, 0, 0, mouseX, mouseY, 1.0f);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }
}

